Rem
Rem $Header: generate_georaster.sql 07-jan-2007.07:24:38 bgouslin Exp $
Rem
Rem generate_georaster.sql
Rem
Rem Copyright (c) 2002, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      generate_georaster.sql 
Rem
Rem    DESCRIPTION
Rem      Generate blank georaster objects and others for the the demos.
Rem      Please note, the GeoRaster objects in the way it is generated 
Rem      is only for demo purposes. Typical GeoRaster objects should be
Rem      loaded from other sources or as results of a process on other 
Rem      GeoRaster objects.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    bgouslin    01/07/07 - New version to fix Windoze format issue caused by
Rem                           some ADE bug
Rem    wexu        02/14/06 - fix blockMBR 
Rem    wexu        08/05/04 - connect as scott 
Rem    qxie        09/24/03 - optionally add rasterid in init() call 
Rem    qxie        07/22/03 - comments
Rem    qxie        02/24/03 - don't delete images
Rem    qxie        11/11/02 - trigger activated
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/28/02 - Created
Rem

connect scott/tiger;

delete from georaster_table where georid = 3;
commit;

-------------------------------------------------------------------
-- create a 2-D blank GeoRaster object
-- 
-- Blank GeoRaster object means all its cells have the same value
-------------------------------------------------------------------

insert into georaster_table values (
  3,
  'BLANK', 
  sdo_geor.createBlank(20001, 
                       MDSYS.SDO_NUMBER_ARRAY(0,0),
                       MDSYS.SDO_NUMBER_ARRAY(1024,1024), 
                       122,
                       'ST_RDT_1',
                       3) );



-------------------------------------------------------------------
-- generate a truecolor GeoRaster object
--
-- It is a 2-D multiband image with scaling/stretching data
-- It's blocked and in BSQ format.
--
-- It's for demo purposes ONLY! Most georaster objects should be
-- either loaded from other or external sources using importFrom
-- or other tools, or generated from existing georaster objects
-- by calling procedures or functions of sdo_geor package
-------------------------------------------------------------------

DECLARE
   geor          MDSYS.SDO_GEORASTER;
   rid           NUMBER := 0;
   raster        MDSYS.SDO_RASTER;
   geom          MDSYS.SDO_GEOMETRY;
   col           NUMBER;
   row           NUMBER;
   colTileOrig   NUMBER;
   rowTileOrig   NUMBER;
   rowTileNum    NUMBER := 1;
   colTileNum    NUMBER := 1;
   i             NUMBER;
   j             NUMBER;
   m             NUMBER;
   n             NUMBER;
   amt           NUMBER;
   pos           NUMBER;
   val           NUMBER(1,0);
   val2          NUMBER(1,0);
   val3          NUMBER(1,0);
   blockSize     NUMBER;
   cellBuf       RAW(32767);
   cellBuf1      RAW(10000);
   cellBuf2      RAW(10000);
   cellBuf3      RAW(10000);
   cellBlock     BLOB;
   cellBlockID   NUMBER;
   cnt           NUMBER;
   stmt          varchar2(1000);
BEGIN
   
   -- assume the georaster object is 512 x 512
   -- blocked into 8*8 tiles of size 64 x 64 
   -- 3 bands or layers and cell depth is 8 bit unsigned

   dbms_output.enable(1000000);

   col := 512;
   row := 512;
   colTileOrig := 0;
   rowTileOrig := 0;
   blockSize := 64;

   --select count(*) into cnt from georaster_table a
   --  where a.georid = 4;
   --if cnt > 0 then
    -- select a.georaster.rasterid into rid 
      -- from georaster_table a where a.georid = 4;
     --delete from st_rdt_1 a where a.rasterID = rid;
   delete from georaster_table where georid = 4;
   --END IF;

   INSERT INTO GEORASTER_TABLE VALUES(
     4, 
     'TRUECOLOR',
     MDSYS.SDO_GEOR.init('ST_RDT_1', 4)
   );

   -- populate spatial extent and metadata 
   select a.georaster into geor from georaster_table a
     where a.georid = 4 for update;

   rid := geor.rasterID;
   dbms_output.put_line('rasterID = '||rid);
   
   geor.rasterType := 21001;
   geor.spatialExtent := 
     MDSYS.SDO_GEOMETRY(2003, NULL, NULL,
       MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,3), 
       MDSYS.SDO_ORDINATE_ARRAY(rowTileOrig, colTileOrig,
                                row-1, col-1));
   geor.metadata := 
XMLTYPE('<georasterMetadata xmlns="http://xmlns.oracle.com/spatial/georaster">
	<objectInfo>
		<rasterType>21001</rasterType>
		<ID>IMAGE_12732</ID>
		<majorVersion>1</majorVersion>
		<minorVersion>12</minorVersion>
		<isBlank>false</isBlank>
		<defaultRed>1</defaultRed>
		<defaultGreen>2</defaultGreen>
		<defaultBlue>3</defaultBlue>
	</objectInfo>
	<rasterInfo>
		<cellRepresentation>UNDEFINED</cellRepresentation>
		<cellDepth>8BIT_U</cellDepth>
		<totalDimensions>3</totalDimensions>
		<dimensionSize type="COLUMN">
			<size>512</size>
		</dimensionSize>
		<dimensionSize type="ROW">
			<size>512</size>
		</dimensionSize>
		<dimensionSize type="BAND">
			<size>3</size>
		</dimensionSize>
		<ULTCoordinate>
			<row>0</row>
			<column>0</column>
			<band>0</band>
		</ULTCoordinate>
		<blocking>
			<type>REGULAR</type>
			<totalRowBlocks>8</totalRowBlocks>
			<totalColumnBlocks>8</totalColumnBlocks>
			<totalBandBlocks>1</totalBandBlocks>
                        <rowBlockSize>64</rowBlockSize>
                        <columnBlockSize>64</columnBlockSize>
                        <bandBlockSize>3</bandBlockSize>
		</blocking>
		<interleaving>BSQ</interleaving>
		<pyramid>
			<type>NONE</type>
			<maxLevel>0</maxLevel>
		</pyramid>
                <compression>
                        <type>NONE</type>
                </compression>
	</rasterInfo>
	<spatialReferenceInfo>
		<isReferenced>true</isReferenced>
		<isRectified>true</isRectified>
		<description>georeferenced landsat TM image</description>
		<SRID>82394</SRID>
		<spatialResolution dimensionType="X">
			<resolution>30.0</resolution>
		</spatialResolution>
		<spatialResolution dimensionType="Y">
			<resolution>30.0</resolution>
		</spatialResolution>
		<spatialTolerance>0.01</spatialTolerance>
		<modelCoordinateLocation>UPPERLEFT</modelCoordinateLocation>
		<modelType>FunctionalFitting</modelType>
		<polynomialModel rowOff="0" columnOff="0" xOff="0" yOff="0" zOff="0" rowScale="1" columnScale="1" xScale="1" yScale="1" zScale="1">
			<pPolynomial nVars="2" order="1" nCoefficients="3">
				<polynomialCoefficients>33772.93015929653 0 -0.03333333333333333</polynomialCoefficients>
			</pPolynomial>
			<qPolynomial nVars="0" order="0" nCoefficients="1">
				<polynomialCoefficients>1</polynomialCoefficients>
			</qPolynomial>
			<rPolynomial nVars="2" order="1" nCoefficients="3">
				<polynomialCoefficients>-606.1258322236894 0.03333333333333333 0</polynomialCoefficients>
			</rPolynomial>
			<sPolynomial nVars="0" order="0" nCoefficients="1">
				<polynomialCoefficients>1</polynomialCoefficients>
			</sPolynomial>
		</polynomialModel>
	</spatialReferenceInfo>
	<temporalReferenceInfo>
		<isReferenced>false</isReferenced>
	</temporalReferenceInfo>
	<bandReferenceInfo>
		<isReferenced>false</isReferenced>
		<description>3 band TM imagery</description>
		<radiometricResolutionDescription>8-bit </radiometricResolutionDescription>
		<spectralUnit>MILLIMETER</spectralUnit>
		<spectralTolerance>0.0</spectralTolerance>
		<minSpectralResolution dimensionType="S">
			<resolution>0.094</resolution>
		</minSpectralResolution>
		<spectralExtent>
			<min>0.43</min>
			<max>0.75</max>
		</spectralExtent>
	</bandReferenceInfo>
	<layerInfo>
                <layerDimension>BAND</layerDimension>
                <subLayer>
                        <layerNumber>1</layerNumber>
                        <layerDimensionOrdinate>0</layerDimensionOrdinate>
                        <layerID>TM2</layerID>
                        <scalingFunction>
                                <a0>0</a0>
                                <a1>20</a1>
                                <b0>1</b0>
                                <b1>0</b1>
                        </scalingFunction>
                        <statisticDataset>
                                <samplingFactor>1</samplingFactor>
                                <MIN>48</MIN>
                                <MAX>57</MAX>
                                <MEAN>53</MEAN>
                                <MEDIAN>53</MEDIAN>
                                <MODEVALUE>48</MODEVALUE>
                                <STD>4</STD>
                        </statisticDataset>
                </subLayer>
                <subLayer>
                        <layerNumber>2</layerNumber>
                        <layerDimensionOrdinate>1</layerDimensionOrdinate>
                        <layerID>TM3</layerID>
                        <scalingFunction>
                                <a0>0</a0>
                                <a1>10</a1>
                                <b0>1</b0>
                                <b1>0</b1>
                        </scalingFunction>
                </subLayer>
                <subLayer>
                        <layerNumber>3</layerNumber>
                        <layerDimensionOrdinate>2</layerDimensionOrdinate>
                        <layerID>TM4</layerID>
                        <scalingFunction>
                                <a0>0</a0>
                                <a1>15</a1>
                                <b0>1</b0>
                                <b1>0</b1>
                        </scalingFunction>
                </subLayer>
	</layerInfo>
	<sourceInfo>Landsat TM image</sourceInfo>
</georasterMetadata>');

   update georaster_table a set a.georaster = geor where a.georid = 4;

   rowTileNum := row/blockSize; -- assume exact division
   colTileNum := col/blockSize;
   val := 0;

   dbms_output.enable(1000000);
   dbms_output.put_line('col number = '||col);
   dbms_output.put_line('row number = '||row);
   dbms_output.put_line('block size = '||blockSize);
   dbms_output.put_line('colTileNum = '||colTileNum);
   dbms_output.put_line('rowTileNum = '||rowTileNum);


   FOR i IN 0..(rowTileNum-1) LOOP
     FOR j IN 0..(colTileNum-1) LOOP
       -- create the block MBR
       geom := MDSYS.SDO_GEOMETRY(2003, NULL, NULL,
                  MDSYS.SDO_ELEM_INFO_ARRAY(1,1003,3), 
                  MDSYS.SDO_ORDINATE_ARRAY(rowTileOrig, colTileOrig,
                        rowTileOrig+blockSize-1, colTileOrig+blockSize-1)); 
       
       cellBlockID := i*1000 + j; 
       dbms_output.put_line('Processing Block: '||cellBlockID);

       -- create the raster block object
       raster := MDSYS.SDO_RASTER(rid, 0, 0, i, j, geom, EMPTY_BLOB());

       -- insert it into the table
       INSERT INTO ST_RDT_1 VALUES (raster);
     
       select b.rasterblock into cellBlock from ST_RDT_1 b
             where b.rasterID = rid and 
                   b.pyramidlevel = 0 and
                   b.bandblocknumber = 0 and
                   b.rowblocknumber = i and
                   b.columnblocknumber = j
             for update;


       -- populate the raster blobs with some random data
       -- here they range from 48 ~ 57

       IF val > 9 THEN
          val := 0;
       END IF;

       amt := blockSize * blockSize;
       cellBuf1 := utl_raw.cast_to_raw(RPAD(to_char(val), amt, to_char(val)));
       if val > 7 THEN
         val2 := val - 1;
         val3 := val - 2;
       ELSE
         val2 := val + 1;
         val3 := val + 2;
       END IF;
       cellBuf2 := utl_raw.cast_to_raw(RPAD(to_char(val2), amt, to_char(val2)));
       cellBuf3 := utl_raw.cast_to_raw(RPAD(to_char(val3), amt, to_char(val3)));
       cellBuf  := utl_raw.concat(cellBuf1, cellBuf2, cellBuf3);
       DBMS_LOB.OPEN(cellBlock, DBMS_LOB.LOB_READWRITE);
       pos := 1;
       amt := amt * 3;
       dbms_output.put_line(' --- populating cells');
       DBMS_LOB.write(cellblock, amt, pos, cellBuf);
       DBMS_LOB.CLOSE(cellBlock);

       colTileOrig := colTileOrig + blockSize;
       val := val + 1;
     END LOOP;
     colTileOrig := 0;
     rowTileOrig := rowTileOrig + blockSize;
     val := 0;
   END LOOP;
   
END;
/
show errors

COMMIT;

